@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.UnsecuredEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Unsecured endpoint describes an endpoint that the pipeline can connect to over clear transport (no encryption in transit).
 * @property credentials Credentials to be presented to the endpoint.
 * @property tunnel Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'.
 * @property url The endpoint URL for Video Analyzer to connect to.
 */
public data class UnsecuredEndpointArgs(
    public val credentials: Output<UsernamePasswordCredentialsArgs>,
    public val tunnel: Output<SecureIotDeviceRemoteTunnelArgs>? = null,
    public val type: Output<String>,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.UnsecuredEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.UnsecuredEndpointArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.UnsecuredEndpointArgs.builder()
            .credentials(credentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tunnel(tunnel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UnsecuredEndpointArgs].
 */
@PulumiTagMarker
public class UnsecuredEndpointArgsBuilder internal constructor() {
    private var credentials: Output<UsernamePasswordCredentialsArgs>? = null

    private var tunnel: Output<SecureIotDeviceRemoteTunnelArgs>? = null

    private var type: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value Credentials to be presented to the endpoint.
     */
    @JvmName("ftarxbnlomlegxay")
    public suspend fun credentials(`value`: Output<UsernamePasswordCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
     */
    @JvmName("jkwplcnlnqyjpmep")
    public suspend fun tunnel(`value`: Output<SecureIotDeviceRemoteTunnelArgs>) {
        this.tunnel = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'.
     */
    @JvmName("dvqhfsuvoubtleax")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The endpoint URL for Video Analyzer to connect to.
     */
    @JvmName("durqcnsfgeaeysum")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Credentials to be presented to the endpoint.
     */
    @JvmName("qeletqcsfixeaoik")
    public suspend fun credentials(`value`: UsernamePasswordCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Credentials to be presented to the endpoint.
     */
    @JvmName("iusuipwootvsvjge")
    public suspend fun credentials(argument: suspend UsernamePasswordCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = UsernamePasswordCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
     */
    @JvmName("wxecewgylrmhgqqq")
    public suspend fun tunnel(`value`: SecureIotDeviceRemoteTunnelArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnel = mapped
    }

    /**
     * @param argument Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
     */
    @JvmName("mdlfjrofmgiexxxq")
    public suspend fun tunnel(argument: suspend SecureIotDeviceRemoteTunnelArgsBuilder.() -> Unit) {
        val toBeMapped = SecureIotDeviceRemoteTunnelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tunnel = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'.
     */
    @JvmName("yrgyvwxevtgamtnl")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The endpoint URL for Video Analyzer to connect to.
     */
    @JvmName("aornaluxgxetwtht")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): UnsecuredEndpointArgs = UnsecuredEndpointArgs(
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
        tunnel = tunnel,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
