@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.UsernamePasswordCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Username and password credentials.
 * @property password Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'.
 * @property username Username to be presented as part of the credentials.
 */
public data class UsernamePasswordCredentialsArgs(
    public val password: Output<String>,
    public val type: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.UsernamePasswordCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.UsernamePasswordCredentialsArgs = com.pulumi.azurenative.videoanalyzer.inputs.UsernamePasswordCredentialsArgs.builder()
        .password(password.applyValue({ args0 -> args0 }))
        .type(type.applyValue({ args0 -> args0 }))
        .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UsernamePasswordCredentialsArgs].
 */
@PulumiTagMarker
public class UsernamePasswordCredentialsArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var type: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
     */
    @JvmName("gdutnlothvrpvktm")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'.
     */
    @JvmName("bmkgvbnmhpmtbtyx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Username to be presented as part of the credentials.
     */
    @JvmName("owcyogfuivplxawl")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
     */
    @JvmName("kymdwvmtqhhsveom")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'.
     */
    @JvmName("oywxhdcnlrvhqnph")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Username to be presented as part of the credentials.
     */
    @JvmName("eeligxpdlmqnrdia")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): UsernamePasswordCredentialsArgs = UsernamePasswordCredentialsArgs(
        password = password ?: throw PulumiNullFieldException("password"),
        type = type ?: throw PulumiNullFieldException("type"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
