@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoMediaInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about the video and audio content.
 * @property segmentLength Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
 */
public data class VideoMediaInfoArgs(
    public val segmentLength: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoMediaInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoMediaInfoArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoMediaInfoArgs.builder()
            .segmentLength(segmentLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoMediaInfoArgs].
 */
@PulumiTagMarker
public class VideoMediaInfoArgsBuilder internal constructor() {
    private var segmentLength: Output<String>? = null

    /**
     * @param value Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
     */
    @JvmName("jxxuijuykywtpjom")
    public suspend fun segmentLength(`value`: Output<String>) {
        this.segmentLength = value
    }

    /**
     * @param value Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
     */
    @JvmName("hphlaqqyifmkpxad")
    public suspend fun segmentLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentLength = mapped
    }

    internal fun build(): VideoMediaInfoArgs = VideoMediaInfoArgs(
        segmentLength = segmentLength,
    )
}
