@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoSequenceAbsoluteTimeMarkersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A sequence of absolute datetime ranges as a string. The datetime values should follow IS08601, and the sum of the ranges should add up to 24 hours or less. Currently, there can be only one range specified in the sequence.
 * @property ranges The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'.
 */
public data class VideoSequenceAbsoluteTimeMarkersArgs(
    public val ranges: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoSequenceAbsoluteTimeMarkersArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoSequenceAbsoluteTimeMarkersArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoSequenceAbsoluteTimeMarkersArgs.builder()
            .ranges(ranges.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoSequenceAbsoluteTimeMarkersArgs].
 */
@PulumiTagMarker
public class VideoSequenceAbsoluteTimeMarkersArgsBuilder internal constructor() {
    private var ranges: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
     */
    @JvmName("elfggmpfhqdrejsy")
    public suspend fun ranges(`value`: Output<String>) {
        this.ranges = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'.
     */
    @JvmName("rivbgoqyghlglurs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
     */
    @JvmName("qxktomdwkewfxhmi")
    public suspend fun ranges(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ranges = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'.
     */
    @JvmName("ynhgokfgnmynfcks")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VideoSequenceAbsoluteTimeMarkersArgs = VideoSequenceAbsoluteTimeMarkersArgs(
        ranges = ranges ?: throw PulumiNullFieldException("ranges"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
