@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A custom preset for encoding audio with the AAC codec.
 * @property bitrateKbps Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.AudioEncoderAac'.
 */
public data class AudioEncoderAacResponse(
    public val bitrateKbps: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.AudioEncoderAacResponse): AudioEncoderAacResponse = AudioEncoderAacResponse(
            bitrateKbps = javaType.bitrateKbps().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
