@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a custom preset for encoding the input content using the encoder processor.
 * @property audioEncoder Describes a custom preset for encoding audio.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.EncoderCustomPreset'.
 * @property videoEncoder Describes a custom preset for encoding video.
 */
public data class EncoderCustomPresetResponse(
    public val audioEncoder: AudioEncoderAacResponse? = null,
    public val type: String,
    public val videoEncoder: VideoEncoderH264Response? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.EncoderCustomPresetResponse): EncoderCustomPresetResponse = EncoderCustomPresetResponse(
            audioEncoder = javaType.audioEncoder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.AudioEncoderAacResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            videoEncoder = javaType.videoEncoder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoEncoderH264Response.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
