@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a built-in preset for encoding the input content using the encoder processor.
 * @property name Name of the built-in encoding preset.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.EncoderSystemPreset'.
 */
public data class EncoderSystemPresetResponse(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.EncoderSystemPresetResponse): EncoderSystemPresetResponse = EncoderSystemPresetResponse(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
