@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The endpoint details.
 * @property endpointUrl The URL of the endpoint.
 * @property type The type of the endpoint.
 */
public data class EndpointResponse(
    public val endpointUrl: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.EndpointResponse): EndpointResponse = EndpointResponse(
            endpointUrl = javaType.endpointUrl().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
