@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Live pipeline represents a unique instance of a live topology, used for real-time ingestion, archiving and publishing of content for a unique RTSP camera.
 * @property bitrateKbps Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to see if the camera bitrate is now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
 * @property description An optional description for the pipeline.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property parameters List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
 * @property state Current state of the pipeline (read-only).
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property topologyName The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline will process content according to the pipeline topology definition.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLivePipelineResult(
    public val bitrateKbps: Int,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val parameters: List<ParameterDefinitionResponse>? = null,
    public val state: String,
    public val systemData: SystemDataResponse,
    public val topologyName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.GetLivePipelineResult): GetLivePipelineResult = GetLivePipelineResult(
            bitrateKbps = javaType.bitrateKbps(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            topologyName = javaType.topologyName(),
            type = javaType.type(),
        )
    }
}
