@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Pipeline job represents a unique instance of a batch topology, used for offline processing of selected portions of archived content.
 * @property description An optional description for the pipeline.
 * @property error Details about the error, in case the pipeline job fails.
 * @property expiration The date-time by when this pipeline job will be automatically deleted from your account.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property parameters List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
 * @property state Current state of the pipeline (read-only).
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property topologyName Reference to an existing pipeline topology. When activated, this pipeline job will process content according to the pipeline topology definition.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPipelineJobResult(
    public val description: String? = null,
    public val error: PipelineJobErrorResponse,
    public val expiration: String,
    public val id: String,
    public val name: String,
    public val parameters: List<ParameterDefinitionResponse>? = null,
    public val state: String,
    public val systemData: SystemDataResponse,
    public val topologyName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.GetPipelineJobResult): GetPipelineJobResult = GetPipelineJobResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.PipelineJobErrorResponse.Companion.toKotlin(args0)
            }),
            expiration = javaType.expiration(),
            id = javaType.id(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            topologyName = javaType.topologyName(),
            type = javaType.type(),
        )
    }
}
