@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Pipeline topology describes the processing steps to be applied when processing content for a particular outcome. The topology should be defined according to the scenario to be achieved and can be reused across many pipeline instances which share the same processing characteristics. For instance, a pipeline topology which captures content from a RTSP camera and archives the content can be reused across many different cameras, as long as the same processing is to be applied across all the cameras. Individual instance properties can be defined through the use of user-defined parameters, which allow for a topology to be parameterized. This allows  individual pipelines refer to different values, such as individual cameras' RTSP endpoints and credentials. Overall a topology is composed of the following:
 *   - Parameters: list of user defined parameters that can be references across the topology nodes.
 *   - Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be ingested from cameras.
 *   - Processors: list of nodes which perform data analysis or transformations.
 *   - Sinks: list of one or more data sinks which allow for data to be stored or exported to other destinations.
 * @property description An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described here.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind Topology kind.
 * @property name The name of the resource
 * @property parameters List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
 * @property processors List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
 * @property sinks List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
 * @property sku Describes the properties of a SKU.
 * @property sources List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPipelineTopologyResult(
    public val description: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val parameters: List<ParameterDeclarationResponse>? = null,
    public val processors: List<EncoderProcessorResponse>? = null,
    public val sinks: List<VideoSinkResponse>,
    public val sku: SkuResponse,
    public val sources: List<Either<RtspSourceResponse, VideoSourceResponse>>,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.GetPipelineTopologyResult): GetPipelineTopologyResult = GetPipelineTopologyResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDeclarationResponse.Companion.toKotlin(args0)
                })
            }),
            processors = javaType.processors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EncoderProcessorResponse.Companion.toKotlin(args0)
                })
            }),
            sinks = javaType.sinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoSinkResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            sources = javaType.sources().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.videoanalyzer.kotlin.outputs.RtspSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
