@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Group level network access control.
 * @property publicNetworkAccess Whether or not public network access is allowed for specified resources under the Video Analyzer account.
 */
public data class GroupLevelAccessControlResponse(
    public val publicNetworkAccess: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.GroupLevelAccessControlResponse): GroupLevelAccessControlResponse = GroupLevelAccessControlResponse(
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
        )
    }
}
