@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The IoT Hub details.
 * @property id The IoT Hub resource identifier.
 * @property identity The IoT Hub identity.
 * @property status The current status of the Iot Hub mapping.
 */
public data class IotHubResponse(
    public val id: String,
    public val identity: ResourceIdentityResponse,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.IotHubResponse): IotHubResponse = IotHubResponse(
            id = javaType.id(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status(),
        )
    }
}
