@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties for access validation based on JSON Web Tokens (JWT).
 * @property audiences List of expected token audiences. Token audience is valid if it matches at least one of the given values.
 * @property claims List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
 * @property issuers List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
 * @property keys List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
 */
public data class JwtAuthenticationResponse(
    public val audiences: List<String>? = null,
    public val claims: List<TokenClaimResponse>? = null,
    public val issuers: List<String>? = null,
    public val keys: List<Either<EccTokenKeyResponse, RsaTokenKeyResponse>>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.JwtAuthenticationResponse): JwtAuthenticationResponse = JwtAuthenticationResponse(
            audiences = javaType.audiences().map({ args0 -> args0 }),
            claims = javaType.claims().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.TokenClaimResponse.Companion.toKotlin(args0)
                })
            }),
            issuers = javaType.issuers().map({ args0 -> args0 }),
            keys = javaType.keys().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EccTokenKeyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.videoanalyzer.kotlin.outputs.RsaTokenKeyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            type = javaType.type(),
        )
    }
}
