@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an input signal to be used on a pipeline node.
 * @property nodeName The name of the upstream node in the pipeline which output is used as input of the current node.
 */
public data class NodeInputResponse(
    public val nodeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.NodeInputResponse): NodeInputResponse = NodeInputResponse(
            nodeName = javaType.nodeName(),
        )
    }
}
