@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A list of PEM formatted certificates.
 * @property certificates PEM formatted public certificates. One certificate per entry.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.PemCertificateList'.
 */
public data class PemCertificateListResponse(
    public val certificates: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.PemCertificateListResponse): PemCertificateListResponse = PemCertificateListResponse(
            certificates = javaType.certificates().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
