@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details about the error for a failed pipeline job.
 * @property code The error code.
 * @property message The error message.
 */
public data class PipelineJobErrorResponse(
    public val code: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.PipelineJobErrorResponse): PipelineJobErrorResponse = PipelineJobErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
