@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Required validation properties for tokens generated with RSA algorithm.
 * @property alg RSA algorithm to be used: RS256, RS384 or RS512.
 * @property e RSA public key exponent.
 * @property kid JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
 * @property n RSA public key modulus.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
 */
public data class RsaTokenKeyResponse(
    public val alg: String,
    public val e: String,
    public val kid: String,
    public val n: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.RsaTokenKeyResponse): RsaTokenKeyResponse = RsaTokenKeyResponse(
            alg = javaType.alg(),
            e = javaType.e(),
            kid = javaType.kid(),
            n = javaType.n(),
            type = javaType.type(),
        )
    }
}
