@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * RTSP source allows for media from an RTSP camera or generic RTSP server to be ingested into a pipeline.
 * @property endpoint RTSP endpoint information for Video Analyzer to connect to. This contains the required information for Video Analyzer to connect to RTSP cameras and/or generic RTSP servers.
 * @property name Node name. Must be unique within the topology.
 * @property transport Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When using TCP, the RTP packets are interleaved on the TCP RTSP connection. When using HTTP, the RTSP messages are exchanged through long lived HTTP connections, and the RTP packages are interleaved in the HTTP connections alongside the RTSP messages.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.RtspSource'.
 */
public data class RtspSourceResponse(
    public val endpoint: Either<TlsEndpointResponse, UnsecuredEndpointResponse>,
    public val name: String,
    public val transport: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.RtspSourceResponse): RtspSourceResponse = RtspSourceResponse(
            endpoint = javaType.endpoint().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.videoanalyzer.kotlin.outputs.TlsEndpointResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.videoanalyzer.kotlin.outputs.UnsecuredEndpointResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            name = javaType.name(),
            transport = javaType.transport().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
