@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * TLS endpoint describes an endpoint that the pipeline can connect to over TLS transport (data is encrypted in transit).
 * @property credentials Credentials to be presented to the endpoint.
 * @property trustedCertificates List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
 * @property tunnel Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.TlsEndpoint'.
 * @property url The endpoint URL for Video Analyzer to connect to.
 * @property validationOptions Validation options to use when authenticating a TLS connection. By default, strict validation is used.
 */
public data class TlsEndpointResponse(
    public val credentials: UsernamePasswordCredentialsResponse,
    public val trustedCertificates: PemCertificateListResponse? = null,
    public val tunnel: SecureIotDeviceRemoteTunnelResponse? = null,
    public val type: String,
    public val url: String,
    public val validationOptions: TlsValidationOptionsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.TlsEndpointResponse): TlsEndpointResponse = TlsEndpointResponse(
            credentials = javaType.credentials().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.UsernamePasswordCredentialsResponse.Companion.toKotlin(args0)
            }),
            trustedCertificates = javaType.trustedCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.PemCertificateListResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tunnel = javaType.tunnel().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SecureIotDeviceRemoteTunnelResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
            validationOptions = javaType.validationOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.TlsValidationOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
