@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Unsecured endpoint describes an endpoint that the pipeline can connect to over clear transport (no encryption in transit).
 * @property credentials Credentials to be presented to the endpoint.
 * @property tunnel Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'.
 * @property url The endpoint URL for Video Analyzer to connect to.
 */
public data class UnsecuredEndpointResponse(
    public val credentials: UsernamePasswordCredentialsResponse,
    public val tunnel: SecureIotDeviceRemoteTunnelResponse? = null,
    public val type: String,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.UnsecuredEndpointResponse): UnsecuredEndpointResponse = UnsecuredEndpointResponse(
            credentials = javaType.credentials().let({ args0 ->
                com.pulumi.azurenative.videoanalyzer.kotlin.outputs.UsernamePasswordCredentialsResponse.Companion.toKotlin(args0)
            }),
            tunnel = javaType.tunnel().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SecureIotDeviceRemoteTunnelResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
        )
    }
}
