@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of the user assigned managed identity used by the Video Analyzer resource.
 * @property clientId The client ID.
 * @property principalId The principal ID.
 */
public data class UserAssignedManagedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.UserAssignedManagedIdentityResponse): UserAssignedManagedIdentityResponse = UserAssignedManagedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
