@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Username and password credentials.
 * @property password Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'.
 * @property username Username to be presented as part of the credentials.
 */
public data class UsernamePasswordCredentialsResponse(
    public val password: String,
    public val type: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.UsernamePasswordCredentialsResponse): UsernamePasswordCredentialsResponse = UsernamePasswordCredentialsResponse(
            password = javaType.password(),
            type = javaType.type(),
            username = javaType.username(),
        )
    }
}
