@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A custom preset for encoding video with the H.264 (AVC) codec.
 * @property bitrateKbps The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
 * @property frameRate The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
 * @property scale Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.VideoEncoderH264'.
 */
public data class VideoEncoderH264Response(
    public val bitrateKbps: String? = null,
    public val frameRate: String? = null,
    public val scale: VideoScaleResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoEncoderH264Response): VideoEncoderH264Response = VideoEncoderH264Response(
            bitrateKbps = javaType.bitrateKbps().map({ args0 -> args0 }).orElse(null),
            frameRate = javaType.frameRate().map({ args0 -> args0 }).orElse(null),
            scale = javaType.scale().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoScaleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
