@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Video flags contain information about the available video actions and its dynamic properties based on the current video state.
 * @property canStream Value indicating whether or not the video can be streamed. Only "archive" type videos can be streamed.
 * @property hasData Value indicating whether or not there has ever been data recorded or uploaded into the video. Newly created videos have this value set to false.
 * @property isInUse Value indicating whether or not the video is currently being referenced be an active pipeline. The fact that is being referenced, doesn't necessarily indicate that data is being received. For example, video recording may be gated on events or camera may not be accessible at the time.
 */
public data class VideoFlagsResponse(
    public val canStream: Boolean,
    public val hasData: Boolean,
    public val isInUse: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoFlagsResponse): VideoFlagsResponse = VideoFlagsResponse(
            canStream = javaType.canStream(),
            hasData = javaType.hasData(),
            isInUse = javaType.isInUse(),
        )
    }
}
