@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download the most recent still image from the video archive in different resolutions. They are available when the video type is 'archive' and preview images are enabled.
 * @property large High resolution preview image URL.
 * @property medium Medium resolution preview image URL.
 * @property small Low resolution preview image URL.
 */
public data class VideoPreviewImageUrlsResponse(
    public val large: String? = null,
    public val medium: String? = null,
    public val small: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoPreviewImageUrlsResponse): VideoPreviewImageUrlsResponse = VideoPreviewImageUrlsResponse(
            large = javaType.large().map({ args0 -> args0 }).orElse(null),
            medium = javaType.medium().map({ args0 -> args0 }).orElse(null),
            small = javaType.small().map({ args0 -> args0 }).orElse(null),
        )
    }
}
