@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Optional flags used to change how video is published. These are only allowed for topologies where "kind" is set to "live".
 * @property disableArchive When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
 * @property disableRtspPublishing When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
 */
public data class VideoPublishingOptionsResponse(
    public val disableArchive: String? = null,
    public val disableRtspPublishing: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoPublishingOptionsResponse): VideoPublishingOptionsResponse = VideoPublishingOptionsResponse(
            disableArchive = javaType.disableArchive().map({ args0 -> args0 }).orElse(null),
            disableRtspPublishing = javaType.disableRtspPublishing().map({ args0 -> args0 }).orElse(null),
        )
    }
}
