@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoindexer.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Azure Video Indexer account.
 * @property accountId The account's data-plane ID. This can be set only when connecting an existing classic account
 * @property accountName The account's name
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Managed service identity (system assigned and/or user assigned identities)
 * @property location The geo-location where the resource lives
 * @property mediaServices The media services details
 * @property name The name of the resource
 * @property provisioningState Gets the status of the account at the time the operation was called.
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags.
 * @property tenantId The account's tenant id
 * @property totalSecondsIndexed An integer representing the total seconds that have been indexed on the account
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAccountResult(
    public val accountId: String? = null,
    public val accountName: String,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String,
    public val mediaServices: MediaServicesForPutRequestResponse? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String,
    public val totalSecondsIndexed: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoindexer.outputs.GetAccountResult): GetAccountResult = GetAccountResult(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoindexer.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            mediaServices = javaType.mediaServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoindexer.kotlin.outputs.MediaServicesForPutRequestResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.videoindexer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId(),
            totalSecondsIndexed = javaType.totalSecondsIndexed(),
            type = javaType.type(),
        )
    }
}
