@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the image template. The type 'None' will remove any identities from the image template.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.virtualmachineimages.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.enums.ResourceIdentityType> {
    UserAssigned(com.pulumi.azurenative.virtualmachineimages.enums.ResourceIdentityType.UserAssigned),
    None(com.pulumi.azurenative.virtualmachineimages.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.enums.ResourceIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
