@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.DistributeVersionerSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Generates version number based on version number of source image
 * @property scheme Version numbering scheme to be used.
 * Expected value is 'Source'.
 */
public data class DistributeVersionerSourceArgs(
    public val scheme: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.DistributeVersionerSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.inputs.DistributeVersionerSourceArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.DistributeVersionerSourceArgs.builder()
            .scheme(scheme.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributeVersionerSourceArgs].
 */
@PulumiTagMarker
public class DistributeVersionerSourceArgsBuilder internal constructor() {
    private var scheme: Output<String>? = null

    /**
     * @param value Version numbering scheme to be used.
     * Expected value is 'Source'.
     */
    @JvmName("sdsmtmdmrxqgnjne")
    public suspend fun scheme(`value`: Output<String>) {
        this.scheme = value
    }

    /**
     * @param value Version numbering scheme to be used.
     * Expected value is 'Source'.
     */
    @JvmName("cjlpktjvdxorwhxf")
    public suspend fun scheme(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    internal fun build(): DistributeVersionerSourceArgs = DistributeVersionerSourceArgs(
        scheme = scheme ?: throw PulumiNullFieldException("scheme"),
    )
}
