@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateIdentityArgs.builder
import com.pulumi.azurenative.virtualmachineimages.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Identity for the image template.
 * @property type The type of identity used for the image template. The type 'None' will remove any identities from the image template.
 * @property userAssignedIdentities The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
 */
public data class ImageTemplateIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateIdentityArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ImageTemplateIdentityArgs].
 */
@PulumiTagMarker
public class ImageTemplateIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of identity used for the image template. The type 'None' will remove any identities from the image template.
     */
    @JvmName("xukssradhcxypycw")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("veecetodaaiyouxh")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("nsilcfugjabibpxl")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("daapnklhcvmvqvca")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of identity used for the image template. The type 'None' will remove any identities from the image template.
     */
    @JvmName("xdwwdtfangxomwup")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("ieqmjapxtntxnxpb")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("durhcnwdjwyfcsbl")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ImageTemplateIdentityArgs = ImageTemplateIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
