@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesVmBootArgs.builder
import com.pulumi.azurenative.virtualmachineimages.kotlin.enums.VMBootOptimizationState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Optimization is applied on the image for a faster VM boot.
 * @property state Enabling this field will improve VM boot time by optimizing the final customized image output.
 */
public data class ImageTemplatePropertiesVmBootArgs(
    public val state: Output<VMBootOptimizationState>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesVmBootArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesVmBootArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesVmBootArgs.builder()
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ImageTemplatePropertiesVmBootArgs].
 */
@PulumiTagMarker
public class ImageTemplatePropertiesVmBootArgsBuilder internal constructor() {
    private var state: Output<VMBootOptimizationState>? = null

    /**
     * @param value Enabling this field will improve VM boot time by optimizing the final customized image output.
     */
    @JvmName("btgwgstiedgscggp")
    public suspend fun state(`value`: Output<VMBootOptimizationState>) {
        this.state = value
    }

    /**
     * @param value Enabling this field will improve VM boot time by optimizing the final customized image output.
     */
    @JvmName("hlwtphukirjrioil")
    public suspend fun state(`value`: VMBootOptimizationState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ImageTemplatePropertiesVmBootArgs = ImageTemplatePropertiesVmBootArgs(
        state = state,
    )
}
