@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateWindowsUpdateCustomizerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Installs Windows Updates. Corresponds to Packer Windows Update Provisioner (https://github.com/rgl/packer-provisioner-windows-update)
 * @property filters Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above link for examples and detailed description of this field.
 * @property name Friendly Name to provide context on what this customization step does
 * @property searchCriteria Criteria to search updates. Omit or specify empty string to use the default (search all). Refer to above link for examples and detailed description of this field.
 * @property type The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
 * Expected value is 'WindowsUpdate'.
 * @property updateLimit Maximum number of updates to apply at a time. Omit or specify 0 to use the default (1000)
 */
public data class ImageTemplateWindowsUpdateCustomizerArgs(
    public val filters: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val searchCriteria: Output<String>? = null,
    public val type: Output<String>,
    public val updateLimit: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateWindowsUpdateCustomizerArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateWindowsUpdateCustomizerArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateWindowsUpdateCustomizerArgs.builder()
            .filters(filters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .searchCriteria(searchCriteria?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .updateLimit(updateLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateWindowsUpdateCustomizerArgs].
 */
@PulumiTagMarker
public class ImageTemplateWindowsUpdateCustomizerArgsBuilder internal constructor() {
    private var filters: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var searchCriteria: Output<String>? = null

    private var type: Output<String>? = null

    private var updateLimit: Output<Int>? = null

    /**
     * @param value Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above link for examples and detailed description of this field.
     */
    @JvmName("yyxgdihsbxludecc")
    public suspend fun filters(`value`: Output<List<String>>) {
        this.filters = value
    }

    @JvmName("hjbwhtdiwipetxnv")
    public suspend fun filters(vararg values: Output<String>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above link for examples and detailed description of this field.
     */
    @JvmName("roaewaqxmuoyudkg")
    public suspend fun filters(values: List<Output<String>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value Friendly Name to provide context on what this customization step does
     */
    @JvmName("fbiwdntairnqfrlu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Criteria to search updates. Omit or specify empty string to use the default (search all). Refer to above link for examples and detailed description of this field.
     */
    @JvmName("hbqdyvjptfnbabve")
    public suspend fun searchCriteria(`value`: Output<String>) {
        this.searchCriteria = value
    }

    /**
     * @param value The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
     * Expected value is 'WindowsUpdate'.
     */
    @JvmName("tefnvydtafbdlpmx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Maximum number of updates to apply at a time. Omit or specify 0 to use the default (1000)
     */
    @JvmName("dlukuxghibculcql")
    public suspend fun updateLimit(`value`: Output<Int>) {
        this.updateLimit = value
    }

    /**
     * @param value Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above link for examples and detailed description of this field.
     */
    @JvmName("nkscqahihawihpin")
    public suspend fun filters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param values Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above link for examples and detailed description of this field.
     */
    @JvmName("oaelpvbasxyerbyr")
    public suspend fun filters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value Friendly Name to provide context on what this customization step does
     */
    @JvmName("wlvjycvhuspoycdh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Criteria to search updates. Omit or specify empty string to use the default (search all). Refer to above link for examples and detailed description of this field.
     */
    @JvmName("ecrbidxggasceqej")
    public suspend fun searchCriteria(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchCriteria = mapped
    }

    /**
     * @param value The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
     * Expected value is 'WindowsUpdate'.
     */
    @JvmName("shhsgbffvxgniije")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Maximum number of updates to apply at a time. Omit or specify 0 to use the default (1000)
     */
    @JvmName("oluoiyykmvxffrmg")
    public suspend fun updateLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateLimit = mapped
    }

    internal fun build(): ImageTemplateWindowsUpdateCustomizerArgs =
        ImageTemplateWindowsUpdateCustomizerArgs(
            filters = filters,
            name = name,
            searchCriteria = searchCriteria,
            type = type ?: throw PulumiNullFieldException("type"),
            updateLimit = updateLimit,
        )
}
