@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.TargetRegionArgs.builder
import com.pulumi.azurenative.virtualmachineimages.kotlin.enums.SharedImageStorageAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the target region information.
 * @property name The name of the region.
 * @property replicaCount The number of replicas of the Image Version to be created in this region. Omit to use the default (1).
 * @property storageAccountType Specifies the storage account type to be used to store the image in this region. Omit to use the default (Standard_LRS).
 */
public data class TargetRegionArgs(
    public val name: Output<String>,
    public val replicaCount: Output<Int>? = null,
    public val storageAccountType: Output<Either<String, SharedImageStorageAccountType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.TargetRegionArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.inputs.TargetRegionArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.TargetRegionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .replicaCount(replicaCount?.applyValue({ args0 -> args0 }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [TargetRegionArgs].
 */
@PulumiTagMarker
public class TargetRegionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var replicaCount: Output<Int>? = null

    private var storageAccountType: Output<Either<String, SharedImageStorageAccountType>>? = null

    /**
     * @param value The name of the region.
     */
    @JvmName("tsaymggmfmpyyqyf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of replicas of the Image Version to be created in this region. Omit to use the default (1).
     */
    @JvmName("nygwbyrwlqydeqei")
    public suspend fun replicaCount(`value`: Output<Int>) {
        this.replicaCount = value
    }

    /**
     * @param value Specifies the storage account type to be used to store the image in this region. Omit to use the default (Standard_LRS).
     */
    @JvmName("cfumviostyinraod")
    public suspend fun storageAccountType(`value`: Output<Either<String, SharedImageStorageAccountType>>) {
        this.storageAccountType = value
    }

    /**
     * @param value The name of the region.
     */
    @JvmName("xgrhvlbdlrqqfwft")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of replicas of the Image Version to be created in this region. Omit to use the default (1).
     */
    @JvmName("pnkggiqxpxckklgi")
    public suspend fun replicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCount = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image in this region. Omit to use the default (Standard_LRS).
     */
    @JvmName("yieyratgajgjlrbu")
    public suspend fun storageAccountType(`value`: Either<String, SharedImageStorageAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image in this region. Omit to use the default (Standard_LRS).
     */
    @JvmName("tclogovmcoyulhor")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SharedImageStorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image in this region. Omit to use the default (Standard_LRS).
     */
    @JvmName("flxuldaadybkbldm")
    public fun storageAccountType(`value`: SharedImageStorageAccountType) {
        val toBeMapped = Either.ofRight<String, SharedImageStorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    internal fun build(): TargetRegionArgs = TargetRegionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        replicaCount = replicaCount,
        storageAccountType = storageAccountType,
    )
}
