@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Uploads files required for validation to VMs (Linux, Windows). Corresponds to Packer file provisioner
 * @property destination The absolute path to a file (with nested directory structures already created) where the file (from sourceUri) will be uploaded to in the VM
 * @property name Friendly Name to provide context on what this validation step does
 * @property sha256Checksum SHA256 checksum of the file provided in the sourceUri field above
 * @property sourceUri The URI of the file to be uploaded to the VM for validation. It can be a github link, Azure Storage URI (authorized or SAS), etc
 * @property type The type of validation you want to use on the Image. For example, "Shell" can be shell validation
 * Expected value is 'File'.
 */
public data class ImageTemplateFileValidatorResponse(
    public val destination: String? = null,
    public val name: String? = null,
    public val sha256Checksum: String? = null,
    public val sourceUri: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateFileValidatorResponse): ImageTemplateFileValidatorResponse = ImageTemplateFileValidatorResponse(
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sha256Checksum = javaType.sha256Checksum().map({ args0 -> args0 }).orElse(null),
            sourceUri = javaType.sourceUri().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
