@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Distribute as a Managed Disk Image.
 * @property artifactTags Tags that will be applied to the artifact once it has been created/updated by the distributor.
 * @property imageId Resource Id of the Managed Disk Image
 * @property location Azure location for the image, should match if image already exists
 * @property runOutputName The name to be used for the associated RunOutput.
 * @property type Type of distribution.
 * Expected value is 'ManagedImage'.
 */
public data class ImageTemplateManagedImageDistributorResponse(
    public val artifactTags: Map<String, String>? = null,
    public val imageId: String,
    public val location: String,
    public val runOutputName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateManagedImageDistributorResponse): ImageTemplateManagedImageDistributorResponse = ImageTemplateManagedImageDistributorResponse(
            artifactTags = javaType.artifactTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            imageId = javaType.imageId(),
            location = javaType.location(),
            runOutputName = javaType.runOutputName(),
            type = javaType.type(),
        )
    }
}
