@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an image source from [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
 * @property exactVersion Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages). This readonly field differs from 'version', only if the value specified in 'version' field is 'latest'.
 * @property offer Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
 * @property planInfo Optional configuration of purchase plan for platform image.
 * @property publisher Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
 * @property sku Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
 * @property type Specifies the type of source image you want to start with.
 * Expected value is 'PlatformImage'.
 * @property version Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages). If 'latest' is specified here, the version is evaluated when the image build takes place, not when the template is submitted.
 */
public data class ImageTemplatePlatformImageSourceResponse(
    public val exactVersion: String,
    public val offer: String? = null,
    public val planInfo: PlatformImagePurchasePlanResponse? = null,
    public val publisher: String? = null,
    public val sku: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplatePlatformImageSourceResponse): ImageTemplatePlatformImageSourceResponse = ImageTemplatePlatformImageSourceResponse(
            exactVersion = javaType.exactVersion(),
            offer = javaType.offer().map({ args0 -> args0 }).orElse(null),
            planInfo = javaType.planInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.PlatformImagePurchasePlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
