@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Runs the specified PowerShell script during the validation phase (Windows). Corresponds to Packer powershell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
 * @property inline Array of PowerShell commands to execute
 * @property name Friendly Name to provide context on what this validation step does
 * @property runAsSystem If specified, the PowerShell script will be run with elevated privileges using the Local System user. Can only be true when the runElevated field above is set to true.
 * @property runElevated If specified, the PowerShell script will be run with elevated privileges
 * @property scriptUri URI of the PowerShell script to be run for validation. It can be a github link, Azure Storage URI, etc
 * @property sha256Checksum SHA256 checksum of the power shell script provided in the scriptUri field above
 * @property type The type of validation you want to use on the Image. For example, "Shell" can be shell validation
 * Expected value is 'PowerShell'.
 * @property validExitCodes Valid exit codes for the PowerShell script. [Default: 0]
 */
public data class ImageTemplatePowerShellValidatorResponse(
    public val `inline`: List<String>? = null,
    public val name: String? = null,
    public val runAsSystem: Boolean? = null,
    public val runElevated: Boolean? = null,
    public val scriptUri: String? = null,
    public val sha256Checksum: String? = null,
    public val type: String,
    public val validExitCodes: List<Int>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplatePowerShellValidatorResponse): ImageTemplatePowerShellValidatorResponse = ImageTemplatePowerShellValidatorResponse(
            `inline` = javaType.`inline`().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            runAsSystem = javaType.runAsSystem().map({ args0 -> args0 }).orElse(null),
            runElevated = javaType.runElevated().map({ args0 -> args0 }).orElse(null),
            scriptUri = javaType.scriptUri().map({ args0 -> args0 }).orElse(null),
            sha256Checksum = javaType.sha256Checksum().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            validExitCodes = javaType.validExitCodes().map({ args0 -> args0 }),
        )
    }
}
