@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reboots a VM and waits for it to come back online (Windows). Corresponds to Packer windows-restart provisioner
 * @property name Friendly Name to provide context on what this customization step does
 * @property restartCheckCommand Command to check if restart succeeded [Default: '']
 * @property restartCommand Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
 * @property restartTimeout Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
 * @property type The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
 * Expected value is 'WindowsRestart'.
 */
public data class ImageTemplateRestartCustomizerResponse(
    public val name: String? = null,
    public val restartCheckCommand: String? = null,
    public val restartCommand: String? = null,
    public val restartTimeout: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateRestartCustomizerResponse): ImageTemplateRestartCustomizerResponse = ImageTemplateRestartCustomizerResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            restartCheckCommand = javaType.restartCheckCommand().map({ args0 -> args0 }).orElse(null),
            restartCommand = javaType.restartCommand().map({ args0 -> args0 }).orElse(null),
            restartTimeout = javaType.restartTimeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
