@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Distribute via Azure Compute Gallery.
 * @property artifactTags Tags that will be applied to the artifact once it has been created/updated by the distributor.
 * @property excludeFromLatest Flag that indicates whether created image version should be excluded from latest. Omit to use the default (false).
 * @property galleryImageId Resource Id of the Azure Compute Gallery image
 * @property replicationRegions [Deprecated] A list of regions that the image will be replicated to. This list can be specified only if targetRegions is not specified. This field is deprecated - use targetRegions instead.
 * @property runOutputName The name to be used for the associated RunOutput.
 * @property storageAccountType [Deprecated] Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS). This field can be specified only if replicationRegions is specified. This field is deprecated - use targetRegions instead.
 * @property targetRegions The target regions where the distributed Image Version is going to be replicated to. This object supersedes replicationRegions and can be specified only if replicationRegions is not specified.
 * @property type Type of distribution.
 * Expected value is 'SharedImage'.
 * @property versioning Describes how to generate new x.y.z version number for distribution.
 */
public data class ImageTemplateSharedImageDistributorResponse(
    public val artifactTags: Map<String, String>? = null,
    public val excludeFromLatest: Boolean? = null,
    public val galleryImageId: String,
    public val replicationRegions: List<String>? = null,
    public val runOutputName: String,
    public val storageAccountType: String? = null,
    public val targetRegions: List<TargetRegionResponse>? = null,
    public val type: String,
    public val versioning: Either<DistributeVersionerLatestResponse, DistributeVersionerSourceResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateSharedImageDistributorResponse): ImageTemplateSharedImageDistributorResponse = ImageTemplateSharedImageDistributorResponse(
            artifactTags = javaType.artifactTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            excludeFromLatest = javaType.excludeFromLatest().map({ args0 -> args0 }).orElse(null),
            galleryImageId = javaType.galleryImageId(),
            replicationRegions = javaType.replicationRegions().map({ args0 -> args0 }),
            runOutputName = javaType.runOutputName(),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
            targetRegions = javaType.targetRegions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.TargetRegionResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            versioning = javaType.versioning().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.DistributeVersionerLatestResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.DistributeVersionerSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
        )
    }
}
