@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an image source that is an image version in an Azure Compute Gallery or a Direct Shared Gallery.
 * @property exactVersion Exact ARM resource id of the image version. This readonly field differs from the image version Id in 'imageVersionId' only if the version name specified in 'imageVersionId' field is 'latest'.
 * @property imageVersionId ARM resource id of the image version. When image version name is 'latest', the version is evaluated when the image build takes place.
 * @property type Specifies the type of source image you want to start with.
 * Expected value is 'SharedImageVersion'.
 */
public data class ImageTemplateSharedImageVersionSourceResponse(
    public val exactVersion: String,
    public val imageVersionId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateSharedImageVersionSourceResponse): ImageTemplateSharedImageVersionSourceResponse =
            ImageTemplateSharedImageVersionSourceResponse(
                exactVersion = javaType.exactVersion(),
                imageVersionId = javaType.imageVersionId(),
                type = javaType.type(),
            )
    }
}
