@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Runs a shell script during the customization phase (Linux). Corresponds to Packer shell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
 * @property inline Array of shell commands to execute
 * @property name Friendly Name to provide context on what this customization step does
 * @property scriptUri URI of the shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
 * @property sha256Checksum SHA256 checksum of the shell script provided in the scriptUri field
 * @property type The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
 * Expected value is 'Shell'.
 */
public data class ImageTemplateShellCustomizerResponse(
    public val `inline`: List<String>? = null,
    public val name: String? = null,
    public val scriptUri: String? = null,
    public val sha256Checksum: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateShellCustomizerResponse): ImageTemplateShellCustomizerResponse = ImageTemplateShellCustomizerResponse(
            `inline` = javaType.`inline`().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            scriptUri = javaType.scriptUri().map({ args0 -> args0 }).orElse(null),
            sha256Checksum = javaType.sha256Checksum().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
