@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Distribute via VHD in a storage account.
 * @property artifactTags Tags that will be applied to the artifact once it has been created/updated by the distributor.
 * @property runOutputName The name to be used for the associated RunOutput.
 * @property type Type of distribution.
 * Expected value is 'VHD'.
 * @property uri Optional Azure Storage URI for the distributed VHD blob. Omit to use the default (empty string) in which case VHD would be published to the storage account in the staging resource group.
 */
public data class ImageTemplateVhdDistributorResponse(
    public val artifactTags: Map<String, String>? = null,
    public val runOutputName: String,
    public val type: String,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateVhdDistributorResponse): ImageTemplateVhdDistributorResponse = ImageTemplateVhdDistributorResponse(
            artifactTags = javaType.artifactTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            runOutputName = javaType.runOutputName(),
            type = javaType.type(),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
