@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the virtual machines used to build and validate images
 * @property osDiskSizeGB Size of the OS disk in GB. Omit or specify 0 to use Azure's default OS disk size.
 * @property userAssignedIdentities Optional array of resource IDs of user assigned managed identities to be configured on the build VM and validation VM. This may include the identity of the image template.
 * @property vmSize Size of the virtual machine used to build, customize and capture images. Omit or specify empty string to use the default (Standard_D1_v2 for Gen1 images and Standard_D2ds_v4 for Gen2 images).
 * @property vnetConfig Optional configuration of the virtual network to use to deploy the build VM and validation VM in. Omit if no specific virtual network needs to be used.
 */
public data class ImageTemplateVmProfileResponse(
    public val osDiskSizeGB: Int? = null,
    public val userAssignedIdentities: List<String>? = null,
    public val vmSize: String? = null,
    public val vnetConfig: VirtualNetworkConfigResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateVmProfileResponse): ImageTemplateVmProfileResponse = ImageTemplateVmProfileResponse(
            osDiskSizeGB = javaType.osDiskSizeGB().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 -> args0 }),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
            vnetConfig = javaType.vnetConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.VirtualNetworkConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
