@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Installs Windows Updates. Corresponds to Packer Windows Update Provisioner (https://github.com/rgl/packer-provisioner-windows-update)
 * @property filters Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above link for examples and detailed description of this field.
 * @property name Friendly Name to provide context on what this customization step does
 * @property searchCriteria Criteria to search updates. Omit or specify empty string to use the default (search all). Refer to above link for examples and detailed description of this field.
 * @property type The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
 * Expected value is 'WindowsUpdate'.
 * @property updateLimit Maximum number of updates to apply at a time. Omit or specify 0 to use the default (1000)
 */
public data class ImageTemplateWindowsUpdateCustomizerResponse(
    public val filters: List<String>? = null,
    public val name: String? = null,
    public val searchCriteria: String? = null,
    public val type: String,
    public val updateLimit: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateWindowsUpdateCustomizerResponse): ImageTemplateWindowsUpdateCustomizerResponse = ImageTemplateWindowsUpdateCustomizerResponse(
            filters = javaType.filters().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            searchCriteria = javaType.searchCriteria().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updateLimit = javaType.updateLimit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
