@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the error happened when create or update an image template
 * @property message Verbose error message about the provisioning failure
 * @property provisioningErrorCode Error code of the provisioning failure
 */
public data class ProvisioningErrorResponse(
    public val message: String? = null,
    public val provisioningErrorCode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ProvisioningErrorResponse): ProvisioningErrorResponse = ProvisioningErrorResponse(
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            provisioningErrorCode = javaType.provisioningErrorCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
