@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the target region information.
 * @property name The name of the region.
 * @property replicaCount The number of replicas of the Image Version to be created in this region. Omit to use the default (1).
 * @property storageAccountType Specifies the storage account type to be used to store the image in this region. Omit to use the default (Standard_LRS).
 */
public data class TargetRegionResponse(
    public val name: String,
    public val replicaCount: Int? = null,
    public val storageAccountType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.TargetRegionResponse): TargetRegionResponse = TargetRegionResponse(
            name = javaType.name(),
            replicaCount = javaType.replicaCount().map({ args0 -> args0 }).orElse(null),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
