@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin

import com.pulumi.azurenative.visualstudio.kotlin.outputs.ExtensionResourcePlanResponse
import com.pulumi.azurenative.visualstudio.kotlin.outputs.ExtensionResourcePlanResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Extension].
 */
@PulumiTagMarker
public class ExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExtensionArgs = ExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExtensionArgsBuilder.() -> Unit) {
        val builder = ExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Extension {
        val builtJavaResource = com.pulumi.azurenative.visualstudio.Extension(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Extension(builtJavaResource)
    }
}

/**
 * The response to an extension resource GET request.
 * Azure REST API version: 2017-11-01-preview. Prior API version in Azure Native 1.x: 2014-04-01-preview.
 * ## Example Usage
 * ### Create an extension resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.VisualStudio.Extension("extension", new()
 *     {
 *         AccountResourceName = "ExampleAccount",
 *         ExtensionResourceName = "ms.example",
 *         Location = "Central US",
 *         Plan = new AzureNative.VisualStudio.Inputs.ExtensionResourcePlanArgs
 *         {
 *             Name = "ExamplePlan",
 *             Product = "ExampleExtensionName",
 *             PromotionCode = "",
 *             Publisher = "ExampleExtensionPublisher",
 *             Version = "1.0",
 *         },
 *         Properties = null,
 *         ResourceGroupName = "VS-Example-Group",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/visualstudio/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := visualstudio.NewExtension(ctx, "extension", &visualstudio.ExtensionArgs{
 * 			AccountResourceName:   pulumi.String("ExampleAccount"),
 * 			ExtensionResourceName: pulumi.String("ms.example"),
 * 			Location:              pulumi.String("Central US"),
 * 			Plan: &visualstudio.ExtensionResourcePlanArgs{
 * 				Name:          pulumi.String("ExamplePlan"),
 * 				Product:       pulumi.String("ExampleExtensionName"),
 * 				PromotionCode: pulumi.String(""),
 * 				Publisher:     pulumi.String("ExampleExtensionPublisher"),
 * 				Version:       pulumi.String("1.0"),
 * 			},
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("VS-Example-Group"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.visualstudio.Extension;
 * import com.pulumi.azurenative.visualstudio.ExtensionArgs;
 * import com.pulumi.azurenative.visualstudio.inputs.ExtensionResourcePlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .accountResourceName("ExampleAccount")
 *             .extensionResourceName("ms.example")
 *             .location("Central US")
 *             .plan(ExtensionResourcePlanArgs.builder()
 *                 .name("ExamplePlan")
 *                 .product("ExampleExtensionName")
 *                 .promotionCode("")
 *                 .publisher("ExampleExtensionPublisher")
 *                 .version("1.0")
 *                 .build())
 *             .properties()
 *             .resourceGroupName("VS-Example-Group")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:visualstudio:Extension ms.example /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{accountResourceName}/extension/{extensionResourceName}
 * ```
 */
public class Extension internal constructor(
    override val javaResource: com.pulumi.azurenative.visualstudio.Extension,
) : KotlinCustomResource(javaResource, ExtensionMapper) {
    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The extension plan that was purchased.
     */
    public val plan: Output<ExtensionResourcePlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource properties.
     */
    public val properties: Output<Map<String, String>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExtensionMapper : ResourceMapper<Extension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.visualstudio.Extension::class == javaResource::class

    override fun map(javaResource: Resource): Extension = Extension(
        javaResource as
            com.pulumi.azurenative.visualstudio.Extension,
    )
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Extension].
 */
public suspend fun extension(name: String, block: suspend ExtensionResourceBuilder.() -> Unit): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun extension(name: String): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
