@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin

import com.pulumi.azurenative.visualstudio.ExtensionArgs.builder
import com.pulumi.azurenative.visualstudio.kotlin.inputs.ExtensionResourcePlanArgs
import com.pulumi.azurenative.visualstudio.kotlin.inputs.ExtensionResourcePlanArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The response to an extension resource GET request.
 * Azure REST API version: 2017-11-01-preview. Prior API version in Azure Native 1.x: 2014-04-01-preview.
 * ## Example Usage
 * ### Create an extension resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.VisualStudio.Extension("extension", new()
 *     {
 *         AccountResourceName = "ExampleAccount",
 *         ExtensionResourceName = "ms.example",
 *         Location = "Central US",
 *         Plan = new AzureNative.VisualStudio.Inputs.ExtensionResourcePlanArgs
 *         {
 *             Name = "ExamplePlan",
 *             Product = "ExampleExtensionName",
 *             PromotionCode = "",
 *             Publisher = "ExampleExtensionPublisher",
 *             Version = "1.0",
 *         },
 *         Properties = null,
 *         ResourceGroupName = "VS-Example-Group",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/visualstudio/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := visualstudio.NewExtension(ctx, "extension", &visualstudio.ExtensionArgs{
 * 			AccountResourceName:   pulumi.String("ExampleAccount"),
 * 			ExtensionResourceName: pulumi.String("ms.example"),
 * 			Location:              pulumi.String("Central US"),
 * 			Plan: &visualstudio.ExtensionResourcePlanArgs{
 * 				Name:          pulumi.String("ExamplePlan"),
 * 				Product:       pulumi.String("ExampleExtensionName"),
 * 				PromotionCode: pulumi.String(""),
 * 				Publisher:     pulumi.String("ExampleExtensionPublisher"),
 * 				Version:       pulumi.String("1.0"),
 * 			},
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("VS-Example-Group"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.visualstudio.Extension;
 * import com.pulumi.azurenative.visualstudio.ExtensionArgs;
 * import com.pulumi.azurenative.visualstudio.inputs.ExtensionResourcePlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .accountResourceName("ExampleAccount")
 *             .extensionResourceName("ms.example")
 *             .location("Central US")
 *             .plan(ExtensionResourcePlanArgs.builder()
 *                 .name("ExamplePlan")
 *                 .product("ExampleExtensionName")
 *                 .promotionCode("")
 *                 .publisher("ExampleExtensionPublisher")
 *                 .version("1.0")
 *                 .build())
 *             .properties()
 *             .resourceGroupName("VS-Example-Group")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:visualstudio:Extension ms.example /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{accountResourceName}/extension/{extensionResourceName}
 * ```
 * @property accountResourceName The name of the Visual Studio Team Services account resource.
 * @property extensionResourceName The name of the extension.
 * @property location The Azure region of the Visual Studio account associated with this request (i.e 'southcentralus'.)
 * @property plan Extended information about the plan being purchased for this extension resource.
 * @property properties A dictionary of extended properties. This property is currently unused.
 * @property resourceGroupName Name of the resource group within the Azure subscription.
 * @property tags A dictionary of user-defined tags to be stored with the extension resource.
 */
public data class ExtensionArgs(
    public val accountResourceName: Output<String>? = null,
    public val extensionResourceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val plan: Output<ExtensionResourcePlanArgs>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.visualstudio.ExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.visualstudio.ExtensionArgs =
        com.pulumi.azurenative.visualstudio.ExtensionArgs.builder()
            .accountResourceName(accountResourceName?.applyValue({ args0 -> args0 }))
            .extensionResourceName(extensionResourceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExtensionArgs].
 */
@PulumiTagMarker
public class ExtensionArgsBuilder internal constructor() {
    private var accountResourceName: Output<String>? = null

    private var extensionResourceName: Output<String>? = null

    private var location: Output<String>? = null

    private var plan: Output<ExtensionResourcePlanArgs>? = null

    private var properties: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Visual Studio Team Services account resource.
     */
    @JvmName("kjtwmrssvcgaevnc")
    public suspend fun accountResourceName(`value`: Output<String>) {
        this.accountResourceName = value
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("pykteeqkypfkimun")
    public suspend fun extensionResourceName(`value`: Output<String>) {
        this.extensionResourceName = value
    }

    /**
     * @param value The Azure region of the Visual Studio account associated with this request (i.e 'southcentralus'.)
     */
    @JvmName("efdkxdakvnlgykpe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Extended information about the plan being purchased for this extension resource.
     */
    @JvmName("oeqpgngngphtjhpy")
    public suspend fun plan(`value`: Output<ExtensionResourcePlanArgs>) {
        this.plan = value
    }

    /**
     * @param value A dictionary of extended properties. This property is currently unused.
     */
    @JvmName("fophjknwxxeldarp")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group within the Azure subscription.
     */
    @JvmName("qqhwbsrhlocaaxvt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A dictionary of user-defined tags to be stored with the extension resource.
     */
    @JvmName("cqjgcxppdqxfxwsm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Visual Studio Team Services account resource.
     */
    @JvmName("pyuhhpitavdykbgy")
    public suspend fun accountResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountResourceName = mapped
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("pbtywagchidrlvrw")
    public suspend fun extensionResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionResourceName = mapped
    }

    /**
     * @param value The Azure region of the Visual Studio account associated with this request (i.e 'southcentralus'.)
     */
    @JvmName("nyjyaunosteqjnnn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Extended information about the plan being purchased for this extension resource.
     */
    @JvmName("iuoonjquipbwruun")
    public suspend fun plan(`value`: ExtensionResourcePlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument Extended information about the plan being purchased for this extension resource.
     */
    @JvmName("heodpojjmuplklyx")
    public suspend fun plan(argument: suspend ExtensionResourcePlanArgsBuilder.() -> Unit) {
        val toBeMapped = ExtensionResourcePlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value A dictionary of extended properties. This property is currently unused.
     */
    @JvmName("qgssuqmsqnjxnhck")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values A dictionary of extended properties. This property is currently unused.
     */
    @JvmName("ohrdogcdcgjuheda")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group within the Azure subscription.
     */
    @JvmName("snxfoxbsjxmrkwvf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A dictionary of user-defined tags to be stored with the extension resource.
     */
    @JvmName("ryymweseyjjqrnji")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A dictionary of user-defined tags to be stored with the extension resource.
     */
    @JvmName("rclftkcogdhxnlom")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ExtensionArgs = ExtensionArgs(
        accountResourceName = accountResourceName,
        extensionResourceName = extensionResourceName,
        location = location,
        plan = plan,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
