@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin.inputs

import com.pulumi.azurenative.visualstudio.inputs.GetExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountResourceName The name of the Visual Studio Team Services account resource.
 * @property extensionResourceName The name of the extension.
 * @property resourceGroupName Name of the resource group within the Azure subscription.
 */
public data class GetExtensionPlainArgs(
    public val accountResourceName: String,
    public val extensionResourceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.visualstudio.inputs.GetExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.visualstudio.inputs.GetExtensionPlainArgs =
        com.pulumi.azurenative.visualstudio.inputs.GetExtensionPlainArgs.builder()
            .accountResourceName(accountResourceName.let({ args0 -> args0 }))
            .extensionResourceName(extensionResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetExtensionPlainArgsBuilder internal constructor() {
    private var accountResourceName: String? = null

    private var extensionResourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Visual Studio Team Services account resource.
     */
    @JvmName("nchbeopclcljldks")
    public suspend fun accountResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountResourceName = mapped
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("tabvmnvosvudcsam")
    public suspend fun extensionResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.extensionResourceName = mapped
    }

    /**
     * @param value Name of the resource group within the Azure subscription.
     */
    @JvmName("orxoxmiepvqjfpjj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExtensionPlainArgs = GetExtensionPlainArgs(
        accountResourceName = accountResourceName ?: throw PulumiNullFieldException("accountResourceName"),
        extensionResourceName = extensionResourceName ?: throw
            PulumiNullFieldException("extensionResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
